
clear
set more off

cd "C:\Data\Dropbox\Research\2014- Deliberative Polling\Analysis\Replication"
*cd "N:/Private/"
use "04Combined.dta", clear


/* =============================================================================*/
/* PREPARE */
/* =============================================================================*/

*wave 1 as reference group
replace wave = wave-1


gen femaleXprop_female = female*prop_female
gen youngXprop_young = young*prop_young
gen nonwhiteXprop_nonwhite = nonwhite*prop_nonwhite
gen nocollegeXprop_nocollege = nocollege*prop_nocollege
gen democratXprop_democrat = democrat*prop_democrat
gen republicanXprop_republican = republican*prop_republican
gen ageXav_age = age*av_age
gen eduXav_edu = education*av_edu

gen femaleXmod_participation = female*mod_participation
gen femaleXmod_influence = female*mod_influence
gen femaleXmod_pursueagreement = female*mod_pursueagreement
gen youngXmod_participation = young*mod_participation
gen youngXmod_influence = young*mod_influence
gen youngXmod_pursueagreement = young*mod_pursueagreement
gen nonwhiteXmod_participation = nonwhite*mod_participation
gen nonwhiteXmod_influence = nonwhite*mod_influence
gen nonwhiteXmod_pursueagreement = nonwhite*mod_pursueagreement
gen nocollegeXmod_participation = nocollege*mod_participation
gen nocollegeXmod_influence = nocollege*mod_influence
gen nocollegeXmod_pursueagreement = nocollege*mod_pursueagreement



*cd "N:/Private/Results"
cd "C:\Data\Dropbox\Research\2014- Deliberative Polling\Analysis\Replication\Results"

/* =============================================================================*/
/* DESCRIPTIVE AND CHECK */
/* =============================================================================*/
sum dv_* female young nonwhite nocollege prop_*

pwcorr prop_female prop_young prop_nonwhite prop_nocollege female young nonwhite nocollege democrat republican, sig

foreach trt of varlist prop_female prop_young prop_nonwhite prop_nocollege {
	reg `trt' female young nonwhite nocollege sitedum2-sitedum27
	outreg2 using balance_nopid, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) word append
}



/* =============================================================================*/
/* ANALYSIS */
/* =============================================================================*/

set more off

/*Main analysis.*/
/*DV: small group, respect, efficacy*/
/*IV: individual characteristic and group composition*/
local sgroup "female young nonwhite nocollege"
foreach subgroup of local sgroup {
	foreach yvar of varlist dv_small_group dv_respect dv_efficacy {
		reg `yvar' grp_size `subgroup' prop_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup' prop_`subgroup' using mainreg_step1, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append

		reg `yvar' grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' using mainreg_step2, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
		
		foreach moderator of varlist mod_participation mod_influence mod_pursueagreement {
			reg `yvar' grp_size `subgroup' prop_`subgroup' `moderator' sitedum2-sitedum27, cluster(sitegroup)
			outreg2 grp_size `subgroup' prop_`subgroup' `moderator' using exp_moderator_step1, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
			
			reg `yvar' grp_size `subgroup'X`moderator' `subgroup' prop_`subgroup' `moderator' sitedum2-sitedum27, cluster(sitegroup)
			outreg2 grp_size `subgroup'X`moderator' `subgroup' prop_`subgroup' `moderator' using exp_moderator_step2, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
		}
	}
}

/*Large group and Off-session Experience*/
/*DV: whole experience, large group session, off-session interactions*/
/*IV: individual characteristic and group composition*/
local sgroup "female young nonwhite nocollege"
foreach subgroup of local sgroup {
	foreach yvar of varlist dv_whole dv_large_group dv_offsession {
		reg `yvar' grp_size `subgroup' prop_`subgroup' sitedum2-sitedum27, cluster(site)
		outreg2 grp_size `subgroup' prop_`subgroup' using dv_offsession, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel
	}
}


/*Moderator evaluation - higher score means better moderator*/
/*DV: encouraging participation, influencing participants, pursuing agreement*/
/*IV: individual characteristic and group composition*/
set more off
local sgroup "female young nonwhite nocollege"
foreach subgroup of local sgroup {
	foreach yvar of varlist mod_participation mod_influence mod_pursueagreement {
		reg `yvar' grp_size `subgroup' prop_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup' prop_`subgroup' using dvmoderator_step1, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
		
		reg `yvar' grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' using dvmoderator_step2, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
	}
}



/* =============================================================================*/
/* JEPS REVIEWER REQUESTS */
/* =============================================================================*/

set more off
/*ANALYZING ONLY MIXED-COMPOSITION GROUPS*/
/*DV: small group, respect, efficacy*/
/*IV: individual characteristic and group composition*/
local sgroup "female young nonwhite nocollege"
foreach subgroup of local sgroup {
	foreach yvar of varlist dv_small_group dv_respect dv_efficacy {
		reg `yvar' grp_size `subgroup' prop_`subgroup' sitedum2-sitedum27 if prop_`subgroup' > 0, cluster(sitegroup)
		outreg2 grp_size `subgroup' prop_`subgroup' using mixedonly_step1, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append

		reg `yvar' grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' sitedum2-sitedum27  if prop_`subgroup' > 0, cluster(sitegroup)
		outreg2 grp_size `subgroup'Xprop_`subgroup' `subgroup' prop_`subgroup' using mixedonly_step2, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
		
	}
}

/*DUMMY WHETHER ALONE*/
/*DV: small group, respect, efficacy*/
/*IV: individual characteristic and dummy whether alone in group*/
gen alone_female = prop_female==0
gen alone_young = prop_young==0
gen alone_nonwhite = prop_nonwhite==0
gen alone_nocollege = prop_nocollege==0

gen femaleXalone_female = female*alone_female
gen youngXalone_young = young*alone_young
gen nonwhiteXalone_nonwhite = nonwhite*alone_nonwhite
gen nocollegeXalone_nocollege = nocollege*alone_nocollege

local sgroup "female young nonwhite nocollege"
foreach subgroup of local sgroup {
	foreach yvar of varlist dv_small_group dv_respect dv_efficacy {
		reg `yvar' grp_size `subgroup' alone_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup' alone_`subgroup' using mixedalone_step1, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append

		reg `yvar' grp_size `subgroup'Xalone_`subgroup' `subgroup' alone_`subgroup' sitedum2-sitedum27, cluster(sitegroup)
		outreg2 grp_size `subgroup'Xalone_`subgroup' `subgroup' alone_`subgroup' using mixedalone_step2, bdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) excel append
		
	}
}
